using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for BloodUnitDetailsTab.
	/// </summary>
	public class BloodUnitDetailsTab : GUI.controls.BaseControl
	{
		
		/// <summary>
		/// Local instance of bloodunit for property
		/// </summary>
		BOL.BloodUnit _bloodUnit;

		#region Controls

		private System.Windows.Forms.TabControl tabUnit;
		private System.Windows.Forms.TabPage tabDetails;
		private System.Windows.Forms.TextBox txtUnitStatus;
		private System.Windows.Forms.TextBox txtVolume;
		private System.Windows.Forms.Label lblUnitStatus;
		private System.Windows.Forms.Label lblVolume;
		private System.Windows.Forms.TextBox txtUnitInDate;
		private System.Windows.Forms.TextBox txtDonationType;
		private System.Windows.Forms.Label lblUnitInDate;
		private System.Windows.Forms.Label lblDonationType;
		private System.Windows.Forms.TabPage tabRestricted;
		private System.Windows.Forms.Panel pnlBiohazard;
		private System.Windows.Forms.PictureBox picBiohazard;
		private System.Windows.Forms.Label lblBiohazard;
		private System.Windows.Forms.TextBox txtRestrictedStatus;
		private System.Windows.Forms.Label lblRestrictedStatus;
		private System.Windows.Forms.TextBox txtRestrictedSSN;
		private System.Windows.Forms.TextBox txtRestrictedName;
		private System.Windows.Forms.Label lblRestrictedSSN;
		private System.Windows.Forms.Label lblRestrictedName;
		private System.Windows.Forms.TabPage tabAssigned;
		private System.Windows.Forms.ListView lvAssigned;
		private System.Windows.Forms.TabPage tabTesting;
		private System.Windows.Forms.ListView lvAntigens;
		private System.Windows.Forms.Label lblSickleCellNeg;
		private System.Windows.Forms.Label lblCMVNeg;
		private System.Windows.Forms.Label lblAntigens;
		private System.Windows.Forms.CheckBox cbSickleCellNeg;
		private System.Windows.Forms.CheckBox cbCMVNeg;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.ColumnHeader colOriginalAntigen;
		private System.Windows.Forms.ColumnHeader colOriginalPosNeg;
		private gov.va.med.vbecs.GUI.controls.VbecsErrorProvider errorProvider1; // **** 508 Compliance ***

		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion


		#region Constructors

		/// <summary>
		/// BloodUnitDetailsTab Blank Constructor
		/// </summary>
		public BloodUnitDetailsTab()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
			//
			this.ClearBloodUnit();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(BloodUnitDetailsTab));
			this.tabUnit = new System.Windows.Forms.TabControl();
			this.tabDetails = new System.Windows.Forms.TabPage();
			this.txtUnitStatus = new System.Windows.Forms.TextBox();
			this.txtVolume = new System.Windows.Forms.TextBox();
			this.lblUnitStatus = new System.Windows.Forms.Label();
			this.lblVolume = new System.Windows.Forms.Label();
			this.txtUnitInDate = new System.Windows.Forms.TextBox();
			this.txtDonationType = new System.Windows.Forms.TextBox();
			this.lblUnitInDate = new System.Windows.Forms.Label();
			this.lblDonationType = new System.Windows.Forms.Label();
			this.tabAssigned = new System.Windows.Forms.TabPage();
			this.lvAssigned = new System.Windows.Forms.ListView();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader8 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader9 = new System.Windows.Forms.ColumnHeader();
			this.tabRestricted = new System.Windows.Forms.TabPage();
			this.pnlBiohazard = new System.Windows.Forms.Panel();
			this.picBiohazard = new System.Windows.Forms.PictureBox();
			this.lblBiohazard = new System.Windows.Forms.Label();
			this.txtRestrictedStatus = new System.Windows.Forms.TextBox();
			this.lblRestrictedStatus = new System.Windows.Forms.Label();
			this.txtRestrictedSSN = new System.Windows.Forms.TextBox();
			this.txtRestrictedName = new System.Windows.Forms.TextBox();
			this.lblRestrictedSSN = new System.Windows.Forms.Label();
			this.lblRestrictedName = new System.Windows.Forms.Label();
			this.tabTesting = new System.Windows.Forms.TabPage();
			this.lvAntigens = new System.Windows.Forms.ListView();
			this.colOriginalAntigen = new System.Windows.Forms.ColumnHeader();
			this.colOriginalPosNeg = new System.Windows.Forms.ColumnHeader();
			this.lblSickleCellNeg = new System.Windows.Forms.Label();
			this.lblCMVNeg = new System.Windows.Forms.Label();
			this.lblAntigens = new System.Windows.Forms.Label();
			this.cbSickleCellNeg = new System.Windows.Forms.CheckBox();
			this.cbCMVNeg = new System.Windows.Forms.CheckBox();
			this.errorProvider1 = new gov.va.med.vbecs.GUI.controls.VbecsErrorProvider();
			this.tabUnit.SuspendLayout();
			this.tabDetails.SuspendLayout();
			this.tabAssigned.SuspendLayout();
			this.tabRestricted.SuspendLayout();
			this.pnlBiohazard.SuspendLayout();
			this.tabTesting.SuspendLayout();
			this.SuspendLayout();
			// 
			// tabUnit
			// 
			this.tabUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabUnit.Controls.Add(this.tabDetails);
			this.tabUnit.Controls.Add(this.tabAssigned);
			this.tabUnit.Controls.Add(this.tabRestricted);
			this.tabUnit.Controls.Add(this.tabTesting);
			this.tabUnit.Location = new System.Drawing.Point(0, 0);
			this.tabUnit.Name = "tabUnit";
			this.tabUnit.SelectedIndex = 0;
			this.tabUnit.Size = new System.Drawing.Size(260, 164);
			this.tabUnit.TabIndex = 0;
			// 
			// tabDetails
			// 
			this.tabDetails.Controls.Add(this.txtUnitStatus);
			this.tabDetails.Controls.Add(this.txtVolume);
			this.tabDetails.Controls.Add(this.lblUnitStatus);
			this.tabDetails.Controls.Add(this.lblVolume);
			this.tabDetails.Controls.Add(this.txtUnitInDate);
			this.tabDetails.Controls.Add(this.txtDonationType);
			this.tabDetails.Controls.Add(this.lblUnitInDate);
			this.tabDetails.Controls.Add(this.lblDonationType);
			this.tabDetails.Location = new System.Drawing.Point(4, 23);
			this.tabDetails.Name = "tabDetails";
			this.tabDetails.Size = new System.Drawing.Size(252, 137);
			this.tabDetails.TabIndex = 3;
			this.tabDetails.Text = "Details";
			// 
			// txtUnitStatus
			// 
			this.txtUnitStatus.AccessibleDescription = "Unit Status";
			this.txtUnitStatus.AccessibleName = "Unit Status";
			this.txtUnitStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUnitStatus.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtUnitStatus.Location = new System.Drawing.Point(84, 50);
			this.txtUnitStatus.Name = "txtUnitStatus";
			this.txtUnitStatus.ReadOnly = true;
			this.txtUnitStatus.Size = new System.Drawing.Size(160, 20);
			this.txtUnitStatus.TabIndex = 3;
			this.txtUnitStatus.Text = "";
			// 
			// txtVolume
			// 
			this.txtVolume.AccessibleDescription = "Volume milliliters";
			this.txtVolume.AccessibleName = "Volume milliliters";
			this.txtVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtVolume.Location = new System.Drawing.Point(84, 74);
			this.txtVolume.Name = "txtVolume";
			this.txtVolume.ReadOnly = true;
			this.txtVolume.Size = new System.Drawing.Size(160, 20);
			this.txtVolume.TabIndex = 4;
			this.txtVolume.Text = "";
			// 
			// lblUnitStatus
			// 
			this.lblUnitStatus.Location = new System.Drawing.Point(4, 50);
			this.lblUnitStatus.Name = "lblUnitStatus";
			this.lblUnitStatus.Size = new System.Drawing.Size(80, 20);
			this.lblUnitStatus.TabIndex = 4;
			this.lblUnitStatus.Text = "Unit Status";
			this.lblUnitStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblVolume
			// 
			this.lblVolume.Location = new System.Drawing.Point(4, 74);
			this.lblVolume.Name = "lblVolume";
			this.lblVolume.Size = new System.Drawing.Size(80, 20);
			this.lblVolume.TabIndex = 6;
			this.lblVolume.Text = "Volume (mL)";
			this.lblVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtUnitInDate
			// 
			this.txtUnitInDate.AccessibleDescription = "Date Received";
			this.txtUnitInDate.AccessibleName = "Date Received";
			this.txtUnitInDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUnitInDate.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtUnitInDate.Location = new System.Drawing.Point(84, 26);
			this.txtUnitInDate.Name = "txtUnitInDate";
			this.txtUnitInDate.ReadOnly = true;
			this.txtUnitInDate.Size = new System.Drawing.Size(160, 20);
			this.txtUnitInDate.TabIndex = 2;
			this.txtUnitInDate.Text = "";
			// 
			// txtDonationType
			// 
			this.txtDonationType.AccessibleDescription = "Donation Type";
			this.txtDonationType.AccessibleName = "Donation Type";
			this.txtDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDonationType.Location = new System.Drawing.Point(84, 2);
			this.txtDonationType.Name = "txtDonationType";
			this.txtDonationType.ReadOnly = true;
			this.txtDonationType.Size = new System.Drawing.Size(160, 20);
			this.txtDonationType.TabIndex = 1;
			this.txtDonationType.Text = "";
			// 
			// lblUnitInDate
			// 
			this.lblUnitInDate.Location = new System.Drawing.Point(4, 26);
			this.lblUnitInDate.Name = "lblUnitInDate";
			this.lblUnitInDate.Size = new System.Drawing.Size(80, 20);
			this.lblUnitInDate.TabIndex = 2;
			this.lblUnitInDate.Text = "Date Received";
			this.lblUnitInDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblDonationType
			// 
			this.lblDonationType.Location = new System.Drawing.Point(4, 2);
			this.lblDonationType.Name = "lblDonationType";
			this.lblDonationType.Size = new System.Drawing.Size(80, 20);
			this.lblDonationType.TabIndex = 0;
			this.lblDonationType.Text = "Donation Type";
			this.lblDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// tabAssigned
			// 
			this.tabAssigned.Controls.Add(this.lvAssigned);
			this.tabAssigned.Location = new System.Drawing.Point(4, 23);
			this.tabAssigned.Name = "tabAssigned";
			this.tabAssigned.Size = new System.Drawing.Size(252, 137);
			this.tabAssigned.TabIndex = 1;
			this.tabAssigned.Text = "Assigned";
			this.tabAssigned.Visible = false;
			// 
			// lvAssigned
			// 
			this.lvAssigned.AccessibleDescription = "Assigned Patients";
			this.lvAssigned.AccessibleName = "Assigned Patients";
			this.lvAssigned.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvAssigned.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader6,
																						 this.columnHeader7,
																						 this.columnHeader8,
																						 this.columnHeader9});
			this.lvAssigned.FullRowSelect = true;
			this.lvAssigned.Location = new System.Drawing.Point(0, 0);
			this.lvAssigned.MultiSelect = false;
			this.lvAssigned.Name = "lvAssigned";
			this.lvAssigned.Size = new System.Drawing.Size(254, 140);
			this.lvAssigned.TabIndex = 0;
			this.lvAssigned.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Patient Name";
			this.columnHeader6.Width = 80;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "Patient ID";
			// 
			// columnHeader8
			// 
			this.columnHeader8.Text = "Specimen UID";
			this.columnHeader8.Width = 80;
			// 
			// columnHeader9
			// 
			this.columnHeader9.Text = "Specimen Expires";
			this.columnHeader9.Width = 80;
			// 
			// tabRestricted
			// 
			this.tabRestricted.Controls.Add(this.pnlBiohazard);
			this.tabRestricted.Controls.Add(this.txtRestrictedStatus);
			this.tabRestricted.Controls.Add(this.lblRestrictedStatus);
			this.tabRestricted.Controls.Add(this.txtRestrictedSSN);
			this.tabRestricted.Controls.Add(this.txtRestrictedName);
			this.tabRestricted.Controls.Add(this.lblRestrictedSSN);
			this.tabRestricted.Controls.Add(this.lblRestrictedName);
			this.tabRestricted.Location = new System.Drawing.Point(4, 23);
			this.tabRestricted.Name = "tabRestricted";
			this.tabRestricted.Size = new System.Drawing.Size(252, 137);
			this.tabRestricted.TabIndex = 0;
			this.tabRestricted.Text = "Restricted";
			this.tabRestricted.Visible = false;
			// 
			// pnlBiohazard
			// 
			this.pnlBiohazard.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.pnlBiohazard.Controls.Add(this.picBiohazard);
			this.pnlBiohazard.Controls.Add(this.lblBiohazard);
			this.pnlBiohazard.Location = new System.Drawing.Point(160, 115);
			this.pnlBiohazard.Name = "pnlBiohazard";
			this.pnlBiohazard.Size = new System.Drawing.Size(88, 20);
			this.pnlBiohazard.TabIndex = 6;
			this.pnlBiohazard.Visible = false;
			// 
			// picBiohazard
			// 
			this.picBiohazard.Image = ((System.Drawing.Image)(resources.GetObject("picBiohazard.Image")));
			this.picBiohazard.Location = new System.Drawing.Point(0, 0);
			this.picBiohazard.Name = "picBiohazard";
			this.picBiohazard.Size = new System.Drawing.Size(24, 20);
			this.picBiohazard.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picBiohazard.TabIndex = 32;
			this.picBiohazard.TabStop = false;
			// 
			// lblBiohazard
			// 
			this.lblBiohazard.ForeColor = System.Drawing.Color.Red;
			this.lblBiohazard.Location = new System.Drawing.Point(28, 0);
			this.lblBiohazard.Name = "lblBiohazard";
			this.lblBiohazard.Size = new System.Drawing.Size(55, 20);
			this.lblBiohazard.TabIndex = 0;
			this.lblBiohazard.Text = "Biohazard";
			this.lblBiohazard.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtRestrictedStatus
			// 
			this.txtRestrictedStatus.AccessibleDescription = "Disease Marker Testing";
			this.txtRestrictedStatus.AccessibleName = "Disease Marker Testing";
			this.txtRestrictedStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtRestrictedStatus.Location = new System.Drawing.Point(84, 70);
			this.txtRestrictedStatus.Multiline = true;
			this.txtRestrictedStatus.Name = "txtRestrictedStatus";
			this.txtRestrictedStatus.ReadOnly = true;
			this.txtRestrictedStatus.Size = new System.Drawing.Size(162, 40);
			this.txtRestrictedStatus.TabIndex = 3;
			this.txtRestrictedStatus.Text = "";
			// 
			// lblRestrictedStatus
			// 
			this.lblRestrictedStatus.Location = new System.Drawing.Point(4, 68);
			this.lblRestrictedStatus.Name = "lblRestrictedStatus";
			this.lblRestrictedStatus.Size = new System.Drawing.Size(84, 26);
			this.lblRestrictedStatus.TabIndex = 4;
			this.lblRestrictedStatus.Text = "Disease Marker Testing";
			this.lblRestrictedStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtRestrictedSSN
			// 
			this.txtRestrictedSSN.AccessibleDescription = "Patient I D";
			this.txtRestrictedSSN.AccessibleName = "Patient I D";
			this.txtRestrictedSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtRestrictedSSN.Location = new System.Drawing.Point(84, 46);
			this.txtRestrictedSSN.Name = "txtRestrictedSSN";
			this.txtRestrictedSSN.ReadOnly = true;
			this.txtRestrictedSSN.Size = new System.Drawing.Size(162, 20);
			this.txtRestrictedSSN.TabIndex = 2;
			this.txtRestrictedSSN.Text = "";
			// 
			// txtRestrictedName
			// 
			this.txtRestrictedName.AccessibleDescription = "Patient Name";
			this.txtRestrictedName.AccessibleName = "Patient Name";
			this.txtRestrictedName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtRestrictedName.Location = new System.Drawing.Point(84, 2);
			this.txtRestrictedName.Multiline = true;
			this.txtRestrictedName.Name = "txtRestrictedName";
			this.txtRestrictedName.ReadOnly = true;
			this.txtRestrictedName.Size = new System.Drawing.Size(162, 40);
			this.txtRestrictedName.TabIndex = 1;
			this.txtRestrictedName.Text = "";
			// 
			// lblRestrictedSSN
			// 
			this.lblRestrictedSSN.Location = new System.Drawing.Point(4, 46);
			this.lblRestrictedSSN.Name = "lblRestrictedSSN";
			this.lblRestrictedSSN.Size = new System.Drawing.Size(84, 20);
			this.lblRestrictedSSN.TabIndex = 2;
			this.lblRestrictedSSN.Text = "Patient ID";
			this.lblRestrictedSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblRestrictedName
			// 
			this.lblRestrictedName.Location = new System.Drawing.Point(4, 2);
			this.lblRestrictedName.Name = "lblRestrictedName";
			this.lblRestrictedName.Size = new System.Drawing.Size(84, 20);
			this.lblRestrictedName.TabIndex = 0;
			this.lblRestrictedName.Text = "Patient Name";
			this.lblRestrictedName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// tabTesting
			// 
			this.tabTesting.Controls.Add(this.lvAntigens);
			this.tabTesting.Controls.Add(this.lblSickleCellNeg);
			this.tabTesting.Controls.Add(this.lblCMVNeg);
			this.tabTesting.Controls.Add(this.lblAntigens);
			this.tabTesting.Controls.Add(this.cbSickleCellNeg);
			this.tabTesting.Controls.Add(this.cbCMVNeg);
			this.tabTesting.Location = new System.Drawing.Point(4, 23);
			this.tabTesting.Name = "tabTesting";
			this.tabTesting.Size = new System.Drawing.Size(252, 137);
			this.tabTesting.TabIndex = 2;
			this.tabTesting.Text = "Testing";
			this.tabTesting.Visible = false;
			// 
			// lvAntigens
			// 
			this.lvAntigens.AccessibleDescription = "R B C Antigens";
			this.lvAntigens.AccessibleName = "R B C Antigens";
			this.lvAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvAntigens.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.colOriginalAntigen,
																						 this.colOriginalPosNeg});
			this.lvAntigens.FullRowSelect = true;
			this.lvAntigens.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.lvAntigens.Location = new System.Drawing.Point(112, 20);
			this.lvAntigens.MultiSelect = false;
			this.lvAntigens.Name = "lvAntigens";
			this.lvAntigens.Size = new System.Drawing.Size(140, 116);
			this.lvAntigens.TabIndex = 3;
			this.lvAntigens.View = System.Windows.Forms.View.Details;
			this.lvAntigens.SelectedIndexChanged += new System.EventHandler(this.lvAntigens_SelectedIndexChanged);
			// 
			// colOriginalAntigen
			// 
			this.colOriginalAntigen.Text = "";
			this.colOriginalAntigen.Width = 55;
			// 
			// colOriginalPosNeg
			// 
			this.colOriginalPosNeg.Text = "";
			this.colOriginalPosNeg.Width = 35;
			// 
			// lblSickleCellNeg
			// 
			this.lblSickleCellNeg.Location = new System.Drawing.Point(0, 48);
			this.lblSickleCellNeg.Name = "lblSickleCellNeg";
			this.lblSickleCellNeg.Size = new System.Drawing.Size(88, 20);
			this.lblSickleCellNeg.TabIndex = 2;
			this.lblSickleCellNeg.Text = "Sickle Cell Neg?";
			this.lblSickleCellNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblCMVNeg
			// 
			this.lblCMVNeg.Location = new System.Drawing.Point(0, 24);
			this.lblCMVNeg.Name = "lblCMVNeg";
			this.lblCMVNeg.Size = new System.Drawing.Size(88, 20);
			this.lblCMVNeg.TabIndex = 0;
			this.lblCMVNeg.Text = "CMV Neg?";
			this.lblCMVNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblAntigens
			// 
			this.lblAntigens.Location = new System.Drawing.Point(112, 4);
			this.lblAntigens.Name = "lblAntigens";
			this.lblAntigens.Size = new System.Drawing.Size(76, 20);
			this.lblAntigens.TabIndex = 4;
			this.lblAntigens.Text = "RBC Antigens";
			this.lblAntigens.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbSickleCellNeg
			// 
			this.cbSickleCellNeg.AccessibleDescription = "Sickle Cell Negitive";
			this.cbSickleCellNeg.AccessibleName = "Sickle Cell Negitive";
			this.cbSickleCellNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbSickleCellNeg.Enabled = false;
			this.cbSickleCellNeg.Location = new System.Drawing.Point(4, 48);
			this.cbSickleCellNeg.Name = "cbSickleCellNeg";
			this.cbSickleCellNeg.Size = new System.Drawing.Size(100, 20);
			this.cbSickleCellNeg.TabIndex = 2;
			this.cbSickleCellNeg.Text = "Sickle Cell Negative";
			// 
			// cbCMVNeg
			// 
			this.cbCMVNeg.AccessibleDescription = "C M V Negitive";
			this.cbCMVNeg.AccessibleName = "C M V Negitive";
			this.cbCMVNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbCMVNeg.Enabled = false;
			this.cbCMVNeg.Location = new System.Drawing.Point(4, 24);
			this.cbCMVNeg.Name = "cbCMVNeg";
			this.cbCMVNeg.Size = new System.Drawing.Size(100, 20);
			this.cbCMVNeg.TabIndex = 1;
			this.cbCMVNeg.Text = "CMV Negative";
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// BloodUnitDetailsTab
			// 
			this.Controls.Add(this.tabUnit);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "BloodUnitDetailsTab";
			this.Size = new System.Drawing.Size(260, 164);
			this.tabUnit.ResumeLayout(false);
			this.tabDetails.ResumeLayout(false);
			this.tabAssigned.ResumeLayout(false);
			this.tabRestricted.ResumeLayout(false);
			this.pnlBiohazard.ResumeLayout(false);
			this.tabTesting.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#endregion


		#region Properties

		/// <summary>
		/// BloodUnit selected
		/// </summary>
		public BOL.BloodUnit BloodUnit
		{
			get
			{
				return this._bloodUnit;
			}
			set
			{
				if (value != null && this._bloodUnit != null)
				{
					if (value.BloodUnitGuid == this._bloodUnit.BloodUnitGuid)
					{
						return;
					}
				}
				this._bloodUnit = value;
				//
				if (this._bloodUnit == null)
				{
					this.ClearBloodUnit();
				}
				else
				{
					this.LoadBloodUnit();
				}
			}
		}

		#endregion


		#region Methods
	

		private void ClearBloodUnit()
		{
			this.txtDonationType.Text = "";
			this.txtUnitInDate.Text = "";
			this.txtUnitStatus.Text = "";
			this.txtVolume.Text = "";
			//
			this.txtRestrictedName.Text = "";
			this.txtRestrictedSSN.Text = "";
			this.txtRestrictedStatus.Text = "";
			this.pnlBiohazard.Visible = false;
			//
			this.lvAssigned.Items.Clear();
			//
			this.cbCMVNeg.Checked = false;
			this.cbSickleCellNeg.Checked = false;
			this.lvAntigens.Items.Clear();
			//
			//Only display additional tabs when information exists
			if (this.tabUnit.TabPages.Contains(tabAssigned))
			{
				this.tabUnit.TabPages.Remove(tabAssigned);
			}
			if (this.tabUnit.TabPages.Contains(tabRestricted))
			{
				this.tabUnit.TabPages.Remove(tabRestricted);
			}
			if (this.tabUnit.TabPages.Contains(tabTesting))
			{
				this.tabUnit.TabPages.Remove(tabTesting);
			}
		}

		private void LoadBloodUnit()
		{
			this.OnUserActivity();

			this.ClearBloodUnit();
			//
			//Tab display order should be (GUI Review 11/20/03):
			//1. Assigned (if assigned/crossmatched)
			//2. Restricted (if autologous/directed)
			//3. Details (always displayed)
			//4. Testing (if antigens exists or CMV Neg/Sickle Cell Neg
			//
			//Assigned Tab
			//if (this._bloodUnit.BloodUnitStatus.UnitStatusCode.ToCharArray()[0] == Common.Utility.GetUnitStatusCodeCharFromEnum(Common.UnitStatusCode.CrossmatchedAssigned))
			if ((this._bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Assigned) ||
				(this._bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.CrossmatchedAssigned))
			{
				if (!this.tabUnit.TabPages.Contains(tabAssigned))
				{
					this.tabUnit.TabPages.Add(tabAssigned);
				}
				//
				DataTable assignedPatientSpecimens = BOL.PatientAssignments.GetPatientSpecimenAssignmentDetails(this._bloodUnit.BloodUnitGuid);
				//
				foreach(DataRow dr in assignedPatientSpecimens.Rows)
				{
					System.Guid patientGUID = (System.Guid)dr[Common.VbecsTables.Patient.PatientGuid];
					BOL.Patient patient = new BOL.Patient(patientGUID);
					//Populate the list view with the appropriate data
					ListViewItem lvi = new ListViewItem(patient.DisplayName);
					lvi.SubItems.Add(patient.DisplayPatientID);//patient.SSN.ToString().Insert(3,"-").Insert(6,"-"));
					//
					System.Guid patientSpecimenGUID = dr.IsNull(Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid) ? Guid.Empty : (System.Guid)dr[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid];
					if (patientSpecimenGUID!=Guid.Empty)
					{
						BOL.Specimen specimen = new BOL.Specimen(patientSpecimenGUID);
						lvi.SubItems.Add(specimen.SpecimenUid);
						lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(specimen.SpecimenExpirationDate));
					}
					else
					{
						lvi.SubItems.Add("Not Required");
					}
					//
					lvAssigned.Items.Add(lvi);
				}
				//
				controls.VbecsFunction.SetColumnWidths(this.lvAssigned);
			}
			else
			{
				//Only display additional tabs when information exists
				if (this.tabUnit.TabPages.Contains(tabAssigned))
				{
					this.tabUnit.TabPages.Remove(tabAssigned);
				}
			}
			//
			//Restricted Tab (always displayed for Trx-Only sites)
			char donation = this._bloodUnit.DonationType.DonationTypeCode;
			BOL.Division division = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);
			//
			if ((!division.ServiceTypeIndicator)||(BOL.BloodUnit.IsDirected(donation)||BOL.BloodUnit.IsAutologous(donation)))
			{
				if (!this.tabUnit.TabPages.Contains(tabRestricted))
				{
					this.tabUnit.TabPages.Add(tabRestricted);
				}

				//11/6/03 - Lohse - put this code in to prevent the SSN blowup -- BloodUnit default is to create a new blank Patient if null
				if (!this._bloodUnit.DirectedPatient.IsNew)
				{
					this.txtRestrictedName.Text = this._bloodUnit.DirectedPatient.DisplayName;
					this.txtRestrictedSSN.Text = this._bloodUnit.DirectedPatient.DisplayPatientID;//SSN.Insert(3,"-").Insert(6,"-");
				}
				if (this._bloodUnit.BloodUnitMedia.TestingStatusId>0)
				{
					this.txtRestrictedStatus.Text = BOL.TestingStatus.GetTestingStatusTextFromID(this._bloodUnit.BloodUnitMedia.TestingStatusId);
					this.pnlBiohazard.Visible = (this._bloodUnit.BloodUnitMedia.TestingStatusId>1);
				}
			}
			else
			{
				//Only display additional tabs when information exists
				if (this.tabUnit.TabPages.Contains(tabRestricted))
				{
					this.tabUnit.TabPages.Remove(tabRestricted);
				}
			}
			//
			//Details Tab
			if (this.tabUnit.TabPages.Contains(this.tabDetails))
			{
				//remove and add, so that it appears next in the list, instead of at the start
				this.tabUnit.TabPages.Remove(this.tabDetails);
				this.tabUnit.TabPages.Add(this.tabDetails);
			}
			txtDonationType.Text = this._bloodUnit.DonationType.DonationTypeText;
			//If date is min date value, don't display
			txtUnitInDate.Text = (this._bloodUnit.IncomingShipment.ShipmentDate == DateTime.MinValue) ? string.Empty : Common.VBECSDateTime.FormatDateTimeString(this._bloodUnit.IncomingShipment.ShipmentDate);
			txtUnitStatus.Text = this._bloodUnit.BloodUnitStatus.UnitStatusDescriptiveText;
			txtVolume.Text = this._bloodUnit.OriginalVolume.ToString();
			
			//
			//Testing Tab
			this.GetAntigens();
			this.GetCmvStatus();
			this.GetSickleCellStatus();
			if ((this.cbCMVNeg.Checked) || (this.cbSickleCellNeg.Checked) || (this.lvAntigens.Items.Count>0))
			{
				if (!this.tabUnit.TabPages.Contains(tabTesting))
				{
					this.tabUnit.TabPages.Add(tabTesting);
				}
			}
			else
			{
				//Only display additional tabs when information exists
				if (this.tabUnit.TabPages.Contains(tabTesting))
				{
					this.tabUnit.TabPages.Remove(tabTesting);
				}
			}
		}

		private void GetCmvStatus()
		{
			try
			{
				DataTable dt = BOL.BloodUnitTest.GetBloodUnitTestResult(this._bloodUnit.BloodUnitGuid,System.Convert.ToInt32(Common.TestType.CMV), this._bloodUnit.DivisionCode);
				if (dt.Rows.Count>0)
				{
					DataRow dr = dt.Rows[0];
					this.cbCMVNeg.Checked = (dr[TABLE.BloodUnitTest.TestResultId].ToString().Trim() == "N");
				}
				else
				{
					this.cbCMVNeg.Checked = false;
				}
				this.errorProvider1.SetVbecsError(this.cbCMVNeg, string.Empty); // **** 508 Compliance ***
			}
			catch (Exception err)
			{
				this.errorProvider1.SetVbecsError(this.cbCMVNeg, err.Message); // **** 508 Compliance ***
				this.cbCMVNeg.Checked = false;
			}
		}

		private void GetSickleCellStatus()
		{
			try
			{
				DataTable dt = BOL.BloodUnitTest.GetBloodUnitTestResult(this._bloodUnit.BloodUnitGuid, System.Convert.ToInt32(Common.TestType.SickleCell), this._bloodUnit.DivisionCode);
				if (dt.Rows.Count>0)
				{
					if (dt.Rows.Count>0)
					{
						DataRow dr = dt.Rows[0];
						this.cbSickleCellNeg.Checked = (dr[TABLE.BloodUnitTest.TestResultId].ToString().Trim() == "N");
					}
					else
					{
						this.cbSickleCellNeg.Checked = false;
					}
				}
				this.errorProvider1.SetVbecsError(this.cbSickleCellNeg, string.Empty); // **** 508 Compliance ***
			}
			catch (Exception err)
			{
				this.errorProvider1.SetVbecsError(this.cbSickleCellNeg, err.Message); // **** 508 Compliance ***
				this.cbSickleCellNeg.Checked = false;
			}
		}

	
		private void GetAntigens()
		{
			this.lvAntigens.Items.Clear();
			//
			try
			{
				//
				//Blood Unit Antigens - entered in UC_01
				System.Data.DataTable antigens = BOL.BloodUnitAntigen.GetBloodUnitAntigens(this._bloodUnit.BloodUnitGuid, this._bloodUnit.DivisionCode);
				//
				foreach (DataRow dr in antigens.Rows)
				{
					ListViewItem lvi = new ListViewItem();

					lvi.Text = dr[Common.VbecsTables.AntigenType.AntigenTypeName].ToString();
					
					if ((bool)dr[Common.VbecsTables.BloodUnitAntigen.Positive])
					{
						lvi.SubItems.Add("POS");
					}
					else
					{
						lvi.SubItems.Add("NEG");
					}
					//
					AddAntigenItem(lvi);
				}
				//
				// Blood Unit Antigen Typing Tests - created by UC_41
				DataTable dtUnitTestResults = BOL.BloodUnitTest.GetBloodUnitTests(this._bloodUnit.BloodUnitGuid, this._bloodUnit.DivisionCode);
				//
				if (dtUnitTestResults.Rows.Count>0)
				{
					DataTable dtAntigenTests = BOL.AntibodyType.GetAntigenTest();
					DataTable dtAntibodyTypes = BOL.AntibodyType.GetAntibodyType();
					//
					foreach(DataRow dr in dtAntigenTests.Rows)
					{
						DataRow[] specificTestResults = dtUnitTestResults.Select(Common.VbecsTables.BloodTestType.BloodTestTypeId + " = " +  dr[Common.VbecsTables.AntigenTest.BloodTestTypeId]);
						DataRow[] specificAntibody = dtAntibodyTypes.Select(Common.VbecsTables.AntigenType.AntigenTypeId + " = " + dr[Common.VbecsTables.AntigenTest.AntigenTypeId]);
						//
						foreach (DataRow drResult in specificTestResults)
						{
							//don't show inconclusive results...
							if (drResult[Common.VbecsTables.TestResult.TestResultId].ToString().Trim() != "I")
							{
								ListViewItem lvi = new ListViewItem();
								//
								//							BOL.BloodTestType testType = new BOL.BloodTestType((int)drResult[Common.VbecsTables.BloodTestType.BloodTestTypeId]);
								lvi.Text = specificAntibody[0][Common.VbecsTables.AntigenType.AntigenTypeName].ToString();
								lvi.SubItems.Add(drResult[Common.VbecsTables.TestResult.TestResultText].ToString());
								AddAntigenItem(lvi);
							}
						}
					}
				}
				//
				controls.VbecsFunction.SetColumnWidths(this.lvAntigens);
				//
				this.errorProvider1.SetVbecsError(this.lblAntigens, String.Empty); // **** 508 Compliance ***
			}
			catch (Exception exp)
			{
				this.errorProvider1.SetVbecsError(this.lblAntigens, exp.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// AddAntigenItem
		/// </summary>
		/// <param name="lvi"></param>
		public void AddAntigenItem(ListViewItem lvi)
		{
			//Only add each antigen test item once...
			bool found = false;
			foreach(ListViewItem lvitem in this.lvAntigens.Items)
			{
				if ((lvi.Text == lvitem.Text)&&(lvi.SubItems[1].Text == lvitem.SubItems[1].Text))
				{
					found = true;
					break;
				}
			}
			if (!found)
			{
				this.lvAntigens.Items.Add(lvi);
			}
		}
		/// <summary>
		/// **** 508 Compliance ***
		/// Get the error messages active for the control
		/// </summary>
		/// <returns></returns>
		public string GetErrorMessages()
		{
			return this.errorProvider1.GetErrorMessages();
		}

		#endregion

		private void lvAntigens_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvAntigens);
		}
	}
}
